# Icinga Knowledge Base - IWKB000003

## Short Message

The service cannot be started/modified/added because it is marked for deletion. Re-Installing the Icinga Agent fails and starting it is also not possible.

## Example Exception

The service cannot be started because it is marked for deletion.

## Reason

In some edge cases it can happen that the `icinga2` service is not removed during an upgrade or uninstallation process. The reason for this is that another tool might have a `lock` on the service, preventing Windows from deleting it. For example this could be the `services` window on where you can manage service, like restarting them or a PowerShell instance you used to work with to modify the service itself.

## Solution

The easiest way of course is to simply reboot the system - this will remove any lock on the service and once Windows is rebooted, the service is deleted.

As this solution is how ever not really usable in enterprise environments, the best approach would be to close all windows which could interact with the service or you interacted with. This includes:

* Windows Task Manager
* PowerShell / Cmd instances
* Services.msc
* Visual Studio Code / PowerShell ISE (because of the PowerShell instance)

Once you found the tool locking the service, it will be removed and you can reinstall the Icinga Agent properly.
